<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$input = Factory::getInput();
$check_in = $input->getString('check_in','');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> element-field-checkin">
        <div class="input-date-checkin">
            <input type="text" class="check-in" id="check-in" value="<?php echo ($check_in!=''?$check_in:'');?>">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo (esc_attr($name));?>">
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/checkin/checkin.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.element-field-checkin','field_checkin',array(
        "input_name"=>$name
),'frontend/app/layouts/WooBooking/form/field/checkin/checkin.js');