'use strict';
(function ($) {
    $.field_checkin = function (element, options) {
        var defaults = {
            input_name:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let now = new Date();
            $(`input[name="${plugin.settings.input_name}"]`).val(moment(now).format('YYYY-MM-DD'));
            $element.find('input[id="check-in"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD'
                },
                maxYear: '+10',
                minDate: now
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name}"]`).val(start.format('YYYY-MM-DD')).trigger('change');
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_checkin = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_checkin')) {
                var plugin = new $.field_checkin(this, options);
                $(this).data('field_checkin', plugin);
            }
        });
    }
})(jQuery);