<?php
namespace WpBookingHotelFrontend\app\helpers;

use WpBookingHotel\Factory;
use WpBookingHotel\Utilities\Utility;

class FrontendHelper
{
    public static $list_key_hotel_properties=array(
        'destination'=>"destination",
        'roomtype'=>'roomtype',
        'discount'=>'discount',
        'service'=>'service',
        'tag'=>'tag',
        'review'=>'review',
        'rate'=>'rate',
    );
    public static function getWpBookingDestinationKey(){
        return self::$list_key_hotel_properties['destination'];
    }
    public static function getWpBookingRoomtypeKey(){
        return self::$list_key_hotel_properties['roomtype'];
    }
    public static function getWpBookingServiceKey(){
        return self::$list_key_hotel_properties['service'];
    }
    public static function getWpBookingDiscountKey(){
        return self::$list_key_hotel_properties['discount'];
    }
    public static function getWpBookingTagKey(){
        return self::$list_key_hotel_properties['tag'];
    }
    public static function getWpBookingReviewKey(){
        return self::$list_key_hotel_properties['review'];
    }
    public static function getWpBookingRateKey(){
        return self::$list_key_hotel_properties['rate'];
    }
    public static function deletePropertyByKey($key='',$id=0) {
        $db= Factory::getDBO();
        $query=$db->getQuery(true);
        $query->clear()
            ->delete(Utility::getTableName('hotelproperty'))
            ->where('hotel_id='.(int)$id)
            ->where('type='.$query->quote($key))
        ;
        $db->setQuery($query)->execute();

    }
    public static function insertNewPropertyByKey($key='', $properties=array(), $hotel_id=0) {
        $db = Factory::getDBO();
        $query =$db->getQuery(true);
        foreach ($properties as $property) {
            $query->clear()
                ->insert(Utility::getTableName('hotelproperty'))
                ->set('object_id='.(int)$property)
                ->set('type='.$query->quote($key))
                ->set('hotel_id='.(int)$hotel_id)
            ;
            $db->setQuery($query)->execute();
        }
    }

    public static function format_currency($cost = 0, $currency = "$")
    {
        return "$currency $cost";
    }

}