<?php

namespace WpBookingHotelFrontend\app\controllers;

use WpBookingHotel\Factory;
use WpBookingHotel\Filesystem\Support\StringController;
use WpBookingHotel\Mvc\Controller\ControllerFrontend;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\ConfigHelper;
use WpBookingHotelFrontend\app\helpers\EmailHelper;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;
defined('_WPBOOKINGHOTEL_EXEC') or die;

/**
 * Class HotelsController
 */
class HotelsController extends ControllerFrontend
{
    public function ajax_get_list_hotel()
    {
        $input = Factory::getInput();
        $data = $input->getData();
        foreach ($data as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            }
        };
        $modelServices=Model::getInstance('hotels');
        $list=$modelServices->get_list_hotel_loc();
        $data = $input->getData();
        $user_id = $data['user_id'];
        foreach ($list as $item){
            //$item->category="Restaurant";
            $item->link= Factory::getRootUrl()."/hotel-detail/".$item->alias.'-'.$item->id;
            $item->lng=$item->lang;
            $item->address="12509 Wayzata Blvd";
            $item->address2="";
            $item->decs= (mb_strimwidth($item->description, 0, 100, "..."));
            $item->city=$item->location->address;
            $item->ctg=$item->category->name;
            $item->state="MN";
            $item->postal="55305";
            $item->web="http:\/\/www.chipotle.com";
            $item->img=Factory::getRootUrlPlugin().$item->image ;
            $item->hours1="Mon-Sun 11am-10pm";
            $item->hours2="";
            $item->hours3="";
            $item->featured="";
            $item->features="Margaritas";
            $item->date="02/17/18";
            $item->fare=$item->price;
            $item->list_star_sum=HtmlFrontend::get_rating_star($item->rating_avg);
            $item->number_review=count($item->list_review);
            $item->address = isset($item->destination)?$item->destination->address:'';
            $item->user_wishlist = $item->user_wishlist;
            $item->hotel_id = $item->id;                        
            $item->check = in_array($user_id,$item->user_wishlist)?true:false;
        }
        echo json_encode($list);
        die;
    }

    public function get_list_services_ajax_form() {
        $input = Factory::getInput();
        $data = $input->getData();
        $dataForms = json_decode( $data['dataObj'] );
        $dataFormsS = array();
        foreach ($dataForms as $key => $dataForm) {
            if( is_array( $dataForm ) ) {
                if( count($dataForm) == 1 ) {
                    if($key == 'room_type_id[]') {
                        $dataFormsS["room_type_id"] = $dataForm;
                    }elseif( $key == 'rating[]' ) {
                        $dataFormsS["rating"] = $dataForm;
                    }else {
                        $dataFormsS[$key] = $dataForm['0'];
                    }
                }else {
                    if($key == 'room_type_id[]') {
                        $dataFormsS['room_type_id'] = $dataForm;
                    }elseif( $key == 'rating[]' ) {
                        $dataFormsS["rating"] = $dataForm;
                    }else {
                        $dataFormsS[$key] = $dataForm;
                    }
                }
            }
        }
        foreach( $dataFormsS as $name => $value ) {
            $input->set($name,$value);
        }
        $modelHotels = Model::getInstance("hotels");
        return $view_list_hotels = $modelHotels->getListHotelsAjax();
    }
}
