<?php

namespace WpBookingHotelFrontend\app\controllers;

use WpBookingHotel\Factory;
use WpBookingHotel\Filesystem\Support\StringController;
use WpBookingHotel\Mvc\Controller\ControllerFrontend;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingHotelFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGHOTEL_EXEC') or die;

/**
 * Class BlockController
 */
class BookingController extends ControllerFrontend
{
    public function book_hotel()
    {
        $appConfig = Factory::getAppConfig();
        $input = Factory::getInput();
        $data = $input->getData();
        $link_redirect = isset($data['link_redirect'])?$data['link_redirect']:'';
        $modelBooking = Model::getInstance('booking');
        $is_enable_send_sms = $appConfig->get('is_enable_send_sms','');
        $order = $modelBooking->book_hotel($data);
        if($is_enable_send_sms == 1) {
            $modelBooking->send_sms_after_booking($order->id);
        }
        header('Location: '.$link_redirect.'?order_id='.$order->id);
        die;

    }

}
