"use strict";
(function ($) {
    $.view_list_hotels = function (element, options) {
        let defaults = {
            render_hotel_grid:"",
            render_hotel_list:"",
            items_per_page: 9,
            visiblePages: 3,
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select.block-sort').select2();
            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function () {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function () {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });

            let $wrapper_hotel_grid = $element.find('.wrapper-hotel-grid');
            let $wrapper_hotel_list = $element.find('.wrapper-hotel-list');
            let $render_hotel_grid = $(plugin.settings.render_hotel_grid);
            let $render_hotel_list = $(plugin.settings.render_hotel_list);
            let $hotel_render_item_grid = $render_hotel_grid.filter('.hotel-render-item');
            let $hotel_render_item_list = $render_hotel_list.filter('.hotel-render-item');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $hotel_render_item_grid.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;
            let $show = $element.find('.content-right .show');

            $element.find('.pagination-hotel').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function (event, page) {
                    var data_page_grid = $hotel_render_item_grid.slice((page - 1) * items_per_page, page * items_per_page);
                    var data_page_list = $hotel_render_item_list.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_hotel_grid.empty();
                    $wrapper_hotel_list.empty();
                    if(total_result < items_per_page) {
                        $show.html(`<span>Showing ${(page-1)*items_per_page + 1} - ${page* total_result} of ${total_result} results</span>`)
                    } else {
                        $show.html(`<span>Showing ${(page-1)*items_per_page + 1} - ${page* items_per_page} of ${total_result} results</span>`)
                    }

                    $.each(data_page_grid, function (index, hotel) {
                        $wrapper_hotel_grid.append(hotel.outerHTML);
                    });
                    $.each(data_page_list, function (index, hotel) {
                        $wrapper_hotel_list.append(hotel.outerHTML);
                    });

                    $('body,html').animate({
                        scrollTop: $element.offset().top
                    },500,"linear");

                }
            });

            $element.find('.sort-display a').on('click',function (e) {
                let $form = $(this).closest('form[name="filter-form"]')
                let key_sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(key_sort);
                $element.find('input[name="direction"]').val(direction);
                $form.submit();
            });
            let $select_sort_item = $element.find('.sort-display a.select-sort-item');
            $.each($select_sort_item, function (index, item) {
                if($(item).hasClass('active')) {
                    let text = $(item).text();
                    $element.find('span.select-by-default').text(text);
                }
            });

            $element.find('.sort-by-block .dropdown').on('click', function () {
                $(this).find('i').addClass('active');
                if($(this).hasClass('open') === false) {
                    $(this).find('i').removeClass('active');
                }
            });
            $element.find('.heart').on('click',function(e){
                $(this).toggleClass('active');
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {

                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        console.log("response",response);
                    }
                });
            })

        };

        
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_hotels = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_hotels')) {
                let plugin = new $.view_list_hotels(this, options);
                $(this).data('view_list_hotels', plugin);
            }
        });
    }
})(jQuery);
