"use strict";
(function ($) {
    $.view_hotel_detail = function (element, options) {
        let defaults = {
            render_list_review:"",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $block_slide = $element.find('.block-slide');
            $element.find('.gallery-slide').slick({
                infinite: true,
                slidesToShow: 3,
                slidesToScroll: 3,
                arrows: true,
                prevArrow: $block_slide.find('.arrow-prev'),
                nextArrow: $block_slide.find('.arrow-next'),
                responsive: [
                    {
                        breakpoint: 1199,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            arrows: false

                        }
                    }
                ]
            });

            $element.find('form[name="form-review"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-save-review').on('click', function () {
                let $form = $(this).closest('form[name="form-review"]');
                let rating = $form.find('input[name="rating"]').val();
                if(rating === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function () {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function () {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });

            $element.find('.btn-select-room-type').on('click', function () {
                let $box_room = $(this).closest('.box-room');
                let room_type_id = $box_room.data('roomtype_id');
                $element.find('select[name="roomtype_id"]').val(room_type_id).trigger('change');
                $('body,html').animate({
                    scrollTop: $element.find('.input-right').offset().top
                }, 500, "linear");
            })

            $element.find('.btn-booking-hotel').on('click', function () {
                let $form = $(this).closest('form[name="booking-form"]');
                let date_checkin = $form.find('input[name="check_in"]').val();
                let date_checkout = $form.find('input[name="check_out"]').val();
                let roomtype_id = $form.find('select[name="roomtype_id"]').val();
                if(date_checkin === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkin</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if(date_checkout === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkout</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if(roomtype_id === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your roomtype</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            console.log('$render_list_review',$render_list_review)
            let $render_item_review = $render_list_review.filter('.render-item-review');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function (event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function (index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });


        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_hotel_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_hotel_detail')) {
                let plugin = new $.view_hotel_detail(this, options);
                $(this).data('view_hotel_detail', plugin);
            }
        });
    }
})(jQuery);
