<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List wishlist");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
$this->user=FactoryAlias::getUser(); 
$curent_user_id = $this->user->id;

?>

<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("category.form")) ?>" name="admin-form" method="post">
    <div class="view-list-category">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"><?php echo (HtmlBackend::render_checkbox('All')) ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Hotel ID','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Hotel Name','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                        <!-- <?php
                            if ($item->user_id == $curent_user_id):
                        ?> -->
                        <tr>
                            <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                            <td class="id nowrap"><?php esc_html_e($item->id); ?></td>
                            <td class="hotel-id nowrap"><?php esc_html_e($item->hotel_id); ?></td>
                            <td class="hotel-name nowrap"><?php esc_html_e($item->hotel_name); ?></td>
                            <td class="service-action">
                                <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("wishlist","wishlist.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="icon-nb-delete"></i></a>
                            </td>
                        </tr>
                        <!-- <?php  endif; ?> -->
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_category.less');
$doc->addScriptApplySelector('.view-list-category', 'view_list_category', array(

), "admin_woopanel/app/assets/js/view_list_category.js");
?>