<?php


use WpBookingHotel\Factory;
use WpBookingHotel\Filesystem\Folder;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility;
WpBookingHotelHtmlWooPanel::load_jquery_library('icheck');
$root_template = WPBOOKINGHOTEL_PATH_ROOT . "/admin/app";
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/assets/less/view_template.less');
?>
<?php
function tree_view($path)
{
	$folders = Folder::folders($path);
	$files = Folder::files($path);
	ob_start();
	?>
    <?php if(!empty((array)$folders))  {?>
        <?php foreach ($folders as $folder) { ?>
            <li>
                <?php
                $a_root = "$path/$folder";
                ?>
                <label>
                    <input type="checkbox" class="node" value="<?php  echo (esc_attr(Utility::get_short_file_by_path($a_root))) ?>">
                    <i class="fas fa-folder"></i>
                    <span class="node" data-node_name="<?php echo ($folder) ?>"><?php echo ($folder) ?></span>
                </label>
                <?php if (count(Folder::folders($a_root)) || count(Folder::files($a_root))) { ?>
                    <ul>
                        <?php echo (tree_view($a_root)) ?>
                    </ul>
                <?php } ?>
            </li>
        <?php } ?>
    <?php } ?>
	<?php foreach ($files as $file) { ?>
    <li>
        <label>
            <input type="checkbox" class="node" value="<?php echo (esc_attr(Utility::get_short_file_by_path("$path/$file"))) ?>">
            <i class="fas fa-file-code"></i>
            <span class="node" data-node_name="<?php echo ($file) ?>"> <?php echo ($file) ?></span>
        </label>
        <span class="view"> <i class="fas fa-eye"></i> <i class="fas fa-eye-slash"></i></span>
    </li>
<?php } ?>
	<?php
	$html = ob_get_clean();
	return $html;
}

?>
    <div class="view-create-template">
        <form>
            <div class="row">
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-12">
                        <?php echo ($this->form->renderField('view_name')) ?>
                    </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="tree-node"><?php echo(tree_view($root_template)) ?></ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="code"></div>
                </div>
            </div>
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-create-template','view_create_template',array(
),'admin_woopanel/app/assets/js/view_create_template.js');