<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List states");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-states">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('State name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Country name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Publish','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="state-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="country-name"><?php echo ($item->country_name); ?> </td>
                        <td class="state-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("states","states.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_states.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-states', 'view_list_states', array(

), "admin_woopanel/app/assets/js/view_list_states.js");
?>