<?php

namespace WpBookingHotelAdminWooPanel\app\views\states;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class StatesView extends View
{
    public function display($tpl)
    {
        $modelState = Model::getInstance("state");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("state.add");
                ToolBar::delete("state.delete_list");
                ToolBar::_clone("state.clone_list");
                $model = Model::getInstance("states");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit state');
                ToolBar::apply("state.apply");
                ToolBar::save("state.save");
                ToolBar::cancel("state.cancel");
                ToolBar::back_to_list("state.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelState->getItem($id);
                $this->form = $modelState->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("state");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}