<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List review");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("review.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-review">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Name','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Email','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Title','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Rating','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Comments','wpbookinghotel')?></th>
                        <th class="nowrap"><?php esc_html_e('Published','wpbookinghotel')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="email nowrap"><?php echo (esc_html($item->email)); ?></td>
                        <td class="title nowrap"><?php echo (esc_html($item->title)); ?></td>
                        <td class="rating nowrap"><?php echo (esc_html($item->rating)); ?></td>
                        <td class="comments nowrap"><?php echo (esc_html($item->comments)); ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public', 'wpbookinghotel');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public', 'wpbookinghotel');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="review-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("review.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("review","review.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_review.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-review', 'view_list_review', array(

), "admin_woopanel/app/assets/js/view_list_review.js");
?>