<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;

?>
<div class="view-review-form">
    <form action="" method="post" name="admin_woopanel-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Review details','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('email')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('title')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rating')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('published')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('comments')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_review.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>
