<?php

namespace WpBookingHotelAdminWooPanel\app\views\review;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class ReviewView extends View
{
    public function display($tpl)
    {
        $modelreview = Model::getInstance("review");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("review.add");
                ToolBar::delete("review.delete_list");
                ToolBar::_clone("review.clone_list");
                $model = Model::getInstance("reviews");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit review');
                ToolBar::apply("review.apply");
                ToolBar::save("review.save");
                ToolBar::cancel("review.cancel");
                ToolBar::back_to_list("review.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelreview->getItem($id);
                $this->form = $modelreview->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("review");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}