<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;

?>
<div class="view-destination-form">
    <form action="" name="admin_woopanel-form" method="post" enctype="multipart/form-data">
        <div>
            <ul class="room-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Details Location','wpbookinghotel') ?></a>
                </li>
                <li role="presentation"><a href="#profile" aria-controls="profile" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Gallery','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('image_location_avatar');
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('name')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('state_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('address')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('iframe')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('banner')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('map_image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('mobile')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('published')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="profile">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
        <?php echo ($this->form->renderField('id')) ?>
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_location.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>