<?php

namespace WpBookingHotelAdminWooPanel\app\views\location;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class LocationView extends View
{
    public function display($tpl)
    {
        $modellocation = Model::getInstance("location");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("location.add");
                ToolBar::delete("location.delete_list");
                ToolBar::_clone('location.clone_list');
                $model = Model::getInstance("locations");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit locations');
                ToolBar::save("location.save");
                ToolBar::cancel('location.cancel');
                ToolBar::apply('location.apply');
                ToolBar::back_to_list('location.back_to_list');
                $id = $input->getInt('id', 0);
                $this->item = $modellocation->getItem($id);
                $this->form = $modellocation->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("location");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}