<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;
?>
<div class="view-hotel-form">
    <form action="" method="post" name="admin_woopanel-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Hotel details','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#gallery" aria-controls="gallery" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Gallery','wpbookinghotel') ?></a></li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-3">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('destination')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('email')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('phone_number')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('max_adult')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('max_child')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('price')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rate')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('room_type_id')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('service')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('facebook','params')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('instagram','params')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('tag')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('published')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="gallery">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_hotel.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>