<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelAdmin\app\Html\HtmlBackend;
use WpBookingHotel\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Discounts");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("discount.form")) ?>" name="admin-form" method="post">
        <div class="view-list-discounts">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php esc_html_e('Discount name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Hotel name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Description','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Publish','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="discount-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="tour-name">
                            <?php foreach ($item->list_hotel as $hotel){ ?>
                                <?php echo "$hotel->name <br/>" ?>
                            <?php } ?>
                        </td>
                        <td class="discount-description">
                            <div><?php echo ($item->description); ?></div>
                        </td>
                        <td class="discount-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookinghotel');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="discount-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("discount.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('discount','discount.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="discounts.add">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_discount.less');
$doc->addScriptApplySelector('.view-list-discounts', 'view_list_discounts', array(

), "admin_woopanel/app/assets/js/view_list_discounts.js");
?>