<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelAdmin\app\Html\HtmlBackend;
use WpBookingHotel\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customize");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customize.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-customize">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php esc_html_e('Table','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Label','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Field','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Type','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Backend','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Frontend','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Default value','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="customize-table">
                            <?php echo (esc_html (ucfirst($item->table_view))); ?>
                        </td>
                        <td class="customize-label">
                            <?php echo (esc_html ($item->label_field)); ?>
                        </td>
                        <td class="customize-field">
                            <?php echo (esc_html ($item->field_name)); ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->type)); ?>
                        </td>
                        <td class="customize-backend">
                            <?php if ($item->backend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-frontend">
                            <?php if ($item->frontend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->default_value)); ?>
                        </td>

                        <td class="customize-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customize.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('customize','customize.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customize.add">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_customize.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-customize', 'view_list_customize', array(

), "admin_woopanel/app/assets/js/view_list_customize.js");
?>