<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;

?>
<div class="view-customers-form">
    <form action="" name="admin_woopanel-form" method="post" enctype="multipart/form-data">
        <div>
            <ul class="room-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Customer detail','wpbookinghotel') ?></a>
                </li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_html_e('Customize','wpbookinghotel') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('first_name')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('last_name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('phone')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('birth_day')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p><?php echo ($this->form->renderField('description')) ?></p>
                        </div>
                    </div>

                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
        <?php echo ($this->form->renderField('id')) ?>

    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_customers.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>