<?php

namespace WpBookingHotelAdminWooPanel\app\views\customers;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class CustomersView extends View
{
    public function display($tpl)
    {
        $modelCustomer = Model::getInstance("customer");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customer.add");
                ToolBar::_clone("customer.clone_list");
                ToolBar::delete("customer.delete_list");
                $model = Model::getInstance("customers");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Customer');
                ToolBar::save('customer.save');
                ToolBar::back_to_list('customer.back_to_list');
                ToolBar::cancel('customer.cancel');
                ToolBar::apply('customer.apply');
                $id = $input->getInt('id', 0);
                $this->item = $modelCustomer->getItem($id);
                $this->form = $modelCustomer->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("customer");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}