<?php

namespace WpBookingHotelAdminWooPanel\app\views\countries;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;

class CountriesView extends View
{
    public function display($tpl)
    {
        $modelCountry = Model::getInstance("country");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("country.add");
                ToolBar::delete("country.delete_list");
                ToolBar::_clone("country.clone_list");
                $model = Model::getInstance("countries");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Country');
                ToolBar::save("country.save");
                ToolBar::cancel("country.cancel");
                ToolBar::apply("country.apply");
                ToolBar::back_to_list("country.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelCountry->getItem($id);
                $this->form = $modelCountry->getForm();

                break;
        }
        return parent::display($tpl);
    }
}