<?php

namespace WpBookingHotelAdminWooPanel\app\views\amenity;

use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotelAdmin\app\helpers\CustomizeHelper;

class AmenityView extends View
{
    public function display($tpl)
    {
        $modelamenity = Model::getInstance("amenity");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("amenity.add");
                ToolBar::delete("amenity.delete_list");
                ToolBar::_clone("amenity.clone_list");
                $model = Model::getInstance("amenity");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit amenity');
                ToolBar::apply("amenity.apply");
                ToolBar::save("amenity.save");
                ToolBar::cancel("amenity.cancel");
                ToolBar::back_to_list("amenity.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelamenity->getItem($id);
                $this->form = $modelamenity->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("amenity");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}