<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\ToolBar;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelAdmin\app\Html\HtmlBackend;
use WpBookingHotel\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Activities");
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("activities.form")) ?>" name="admin-form" method="post">
        <div class="view-list-activities">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Activity name','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Image','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Publish','wpbookinghotel'); ?></th>
                        <th><?php esc_html_e('Description','wpbookinghotel'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="activity-name">
                            <h4>
                                <?php echo ($item->name); ?>
                            </h4>
                        </td>
                        <td class="activity-image">
                            <div class="img-box">
                                <div>
                                    <img src="<?php echo (FactoryAlias::getRootUrlPlugin())?>/<?php echo (esc_attr($item->image)); ?>" alt="<?php esc_attr_e($item->name,'wpbookinghotel')?>">
                                </div>
                            </div>
                        </td>
                        <td class="activity-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="activity-description">
                            <div>
                                <?php echo ($item->description); ?>
                            </div>
                        </td>
                        <td class="activity-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("activities.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookinghotel')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('activities','activity.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookinghotel')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="activities.add">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_activity.less');
$doc->addScriptApplySelector('.view-list-activities', 'view_list_activities', array(

), "admin_woopanel/app/assets/js/view_list_activities.js");
?>