<?php
namespace WpBookingHotelAdminWooPanel\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
class WishlistsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "wishlists";
    /**
     * @var string
     */
    public $table_name = "wishlist";
    public function getListQuery()
    {
        $query = $this->db->getQuery(true);
        $query->clear()
            ->select('wishlist.*')
            ->from($this->getTableName() . ' AS wishlist')
            ->leftJoin($this->getTableName('hotel') . ' AS hotel ON hotel.id =wishlist.hotel_id')
            ->group('wishlist.hotel_id')
            ->select('hotel.name  AS hotel_name')
            ->select("COUNT(wishlist.hotel_id) AS total");
        return $query;
    }
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();
        $list =  $db->setQuery($query)->loadObjectList();
        return $list;
    }
}
