<?php
namespace WpBookingHotelAdminWooPanel\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;

class OrdersModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "orders";
    /**
     * @var string
     */
    public $table_name = "order";

    public function getListQuery()
    {
        $query=$this->db->getQuery(true);
        $query->select('a_order.*')
            ->from($this->getTableName('order').' AS a_order')
            ->leftJoin($this->getTableName('customer').' AS customer ON customer.id=a_order.customer_id')
            ->select('customer.first_name AS customer_first_name,customer.last_name AS customer_last_name')
            ;
        return $query;
    }
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        $list = $db->setQuery($query)->loadObjectList();
        foreach ($list as &$order){
            $order->customer_full_name=Utility::get_full_name($order->customer_first_name,$order->customer_last_name);

        }
        return $list;
    }
    public function get_list_order_in_year()
    {
        $now = Factory::getDate();
        $now1 = $now->modify('-12 month');
        $query = $this->_db->getQuery(true);
        $query->select('order1.*')
            ->select('MONTH(order1.created_date) AS month')
            ->from($this->getTableName('order') . ' AS order1')
            ->where('order1.created_date>=' . $query->quote($now1->toSql()));
        $list = $this->_db->setQuery($query)->loadObjectList();
        return $list;
    }
}
