<?php
namespace WpBookingHotelAdminWooPanel\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotelAdmin\app\helpers\AdminHelper;

class HotelsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "hotels";
    /**
     * @var string
     */
    public $table_name = "hotel";

    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        $list_hotel =  $db->setQuery($query)->loadObjectList();
        foreach ($list_hotel as $hotel){
            $query->clear()
            ->select('DISTINCT location.*')
                ->from($this->getTableName('location').' AS location')
                ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id = location.id')
                ->where('hotelproperty.type='.$query->quote(AdminHelper::getWpBookingDestinationKey()))
                ->where('hotelproperty.hotel_id = '.(int)$hotel->id )
            ;
            $location = $this->db->setQuery($query)->loadObject();
            $hotel->location = $location;
        }

        return $list_hotel;
    }
}
