<?php
namespace WpBookingHotelAdminWooPanel\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use Exception;
use WpBookingHotel\Factory;
use WpBookingHotel\Filesystem\File;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelAdmin\app\helpers\AdminHelper;

class AmenityModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "amenity";
    /**
     * @var string
     */
    public $table_name = "amenity";
    public function save($data = array())
    {

        $item= parent::save($data); // TODO: Change the autogenerated stub
        // insert image
        $image=Factory::getInput()->files->get('image','','raw');
        if(!empty($image['name'])) {
            $name = str_replace(' ', '_',Utility::gen_random_string()) . $image['name'];
            $short_path_image = "upload/roomtype/images/cover/$name";
            $new_file_image_amenity_path = WPBOOKINGHOTEL_PATH_ROOT . DS . $short_path_image;
            if (!File::write($new_file_image_amenity_path, File::read($image['tmp_name']))) {
                throw new Exception(Text::_("can not upload image cover"));
            }
            $item->image = $short_path_image;
            $data = (array)$item;
            $item = parent::save($data);
        }
        return $item;
    }
}
