<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_type_field = array('boolean','text','textarea');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-typefield">
        <select class="table-view" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_html_e('Select type','wpbookinghotel') ?></option>
            <?php foreach ($list_type_field as $type) { ?>
                <option <?php echo ($value == $type ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($type)) ?>"><?php esc_html_e(ucfirst($type),'wpbookinghotel') ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/typefield/typefield.less');
$doc->addScriptApplySelector('.field-typefield','field_typefield',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/typefield/typefield.jquery.js');