<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
$doc = Factory::getDocument();
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/tags/tags.less');
$modelTags = Model::getInstance('tags');
$list_tags = $modelTags->getList();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-tags">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-tags">
            <option value=""> <?php esc_html_e('Select tags','wpbookinghotel') ?></option>
            <?php foreach ($list_tags as $tag) { ?>
                <option <?php echo (in_array($tag->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($tag->id)); ?>"><?php esc_html_e($tag->name,'wpbookinghotel'); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc->addScriptApplySelector('.field-tags', 'field_tags', array(
    "tags" => $list_tags,
    "tags_selected" => $value,
), 'admin_woopanel/app/layouts/WooBooking/form/field/tags/jquery.tags.js');
