<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Utilities\Utility;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> element-field-recurring hide-option">
        <label class="label"><input type="checkbox" name="<?php echo (esc_attr($name)); ?>" value="1"
                                    class="recurring"><span>This is recurring event</span> </label>
        <div class="option form-horizontal">
            <div class="form-group">
                <label for="repeat" class="col-sm-3 control-label ">Repeat Event</label>
                <div class="col-sm-9">
                    <select id="repeat-event" name="<?php echo (esc_attr($name_recurring_repeat)) ?>"
                            class="form-control repeat-event">
                        <option value="weekly">Weekly</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label for="until-when" class="col-sm-3 control-label">Until when?</label>
                <div class="col-sm-9">
                    <input type="text" class="form-control until-when" id="recurring_state">
                    <input type="hidden" name="<?php echo (esc_attr($name_recurring_until)) ?>">
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
WpBookingHotelHtmlWooPanel::load_jquery_library('daterangepicker');
$doc->addLessStyleSheet('admin_woopanel/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/recurring.less');
$doc->addScriptApplySelector('.element-field-recurring', 'field_recurring', array(), 'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/recurring.jquery.js');