<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('moment');
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('daterangepicker');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/rates/rates.less');
$id_by_name = "element_field_". $name;

$modelHotel  = Model::getInstance('hotel');
$input = Factory::getInput();
$hotel_id = $input->getInt('id', 0);
$hotel = $modelHotel->getItem($hotel_id);
$list_rate = isset($hotel->list_rate)?$hotel->list_rate:array();
$template_rate = function ($name_check_in,$date_check_in,$name_check_out, $date_check_out){
    ob_start();
    ?>
    <div class="wrapper-item-rate">
        <div class="input-date input-date-checkin">
            <input type="text" class="check-in" value="<?php echo (esc_attr($date_check_in));?>">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo($name_check_in.'[]');?>" value="<?php echo (esc_attr($date_check_in));?>">
        </div>
        <div class="input-date input-date-checkout">
            <input type="text" class="check-out" value="<?php esc_attr_e($date_check_out);?>">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo($name_check_out.'[]');?>" value="<?php echo (esc_attr($date_check_out));?>">
        </div>
        <div class="button-action">
            <button type="button" class="btn btn-primary btn-add-rate"><i class="far fa-copy"></i></button>
            <button type="button" class="btn btn-danger btn-delete-rate"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
    return $content;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-rates">
        <?php
            if(count($list_rate) == 0) {
                echo($template_rate($name_check_in,null,$name_check_out,null));
            } else {
                foreach ($list_rate as $rate) {
                    echo($template_rate($name_check_in, $rate->check_in, $name_check_out, $rate->check_out));
                }

            }
        ?>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_rates',array(
    "input_name"=>  $name,
    "item_rate"=>$template_rate($name_check_in,null,$name_check_out,null),
    "field_name_check_in"=>$name_check_in,
    "field_name_check_out"=>$name_check_out,
    "list_rate"=>$list_rate
),'admin_woopanel/app/layouts/WooBooking/form/field/rates/jquery.rates.js');
