"use strict";
(function ($) {
    $.field_rates = function (element, options) {
        var defaults = {
            input_name: "",
            item_rate: "",
            field_name_check_in:"",
            field_name_check_out:"",
            list_rate:[]
        };
        var plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_rate = plugin.settings.list_rate;
            let now = new Date();
            let i = 0;

            $element.find('.btn-add-rate').on('click', function(e) {
                ++i;
                plugin.set_task_when_click(i);
            });

            $element.find('.wrapper-item-rate').each(function (index, item) {
                plugin.init_event_rate_item($(item))
            });
            if(list_rate.length === 0) {
                plugin.set_daterangepicker($element.find('.wrapper-item-rate'));
                $element.find(`input[name="${plugin.settings.field_name_check_in['0']}[]"]`).val(moment(now).format("YYYY-MM-DD"));
                $element.find(`input[name="${plugin.settings.field_name_check_out['0']}[]"]`).val(moment(now).add(1, 'd').format("YYYY-MM-DD"));
            } else {
                $.each(list_rate, function (index, item) {
                    plugin.set_daterangepicker($($element.find('.wrapper-item-rate')[index]));
                });

            }



        };

        plugin.set_daterangepicker = function($input_element, i=0) {
            let now = new Date();
            $input_element.find(`input[name="${plugin.settings.field_name_check_in['0']}[]"]`).addClass(`check-in-${i}`);
            $input_element.find(`input[name="${plugin.settings.field_name_check_out['0']}[]"]`).addClass(`check-out-${i}`);
            $input_element.find(`input[class="check-in"]`).daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD'
                },
                maxYear: '+10',
                minDate: now
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.field_name_check_in['0']}[]"].check-in-${i}`).val(start.format('YYYY-MM-DD'));
            });
            $input_element.find(`input[class="check-out"]`).daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD'
                },
                maxYear: '+10',
                minDate: moment(now).add(1, 'd')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.field_name_check_out['0']}[]"].check-out-${i}`).val(start.format('YYYY-MM-DD'));
            });
            $input_element.find('input[class="check-in"]').on('change', function () {
                let date = moment($input_element.find('input[class="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $input_element.find('input[class="check-out"]').data('daterangepicker').minDate = date;
                $input_element.find('input[class="check-out"]').data('daterangepicker').startDate = date;
                $input_element.find('input[class="check-out"]').val(date.format("YYYY-MM-DD"));
                $input_element.find(`input[name="${plugin.settings.field_name_check_out['0']}[]"].check-out-${i}`).val(date.format("YYYY-MM-DD"));
            });
            $input_element.find('input[class="check-out"]').on('change', function () {
                let date = moment($input_element.find('input[class="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $input_element.find('input[class="check-in"]').data('daterangepicker').maxDate = date;
            });
        };

        plugin.init_event_rate_item = function ($item_rate) {
            $item_rate.find('.btn-delete-rate').click(function (e) {
                if ($element.find('.wrapper-item-rate').length > 1) {
                    $item_rate.remove();
                }
            })
        };
        plugin.set_task_when_click = function (i) {

            var $item_rate = $(plugin.settings.item_rate);
            plugin.set_daterangepicker($item_rate.find('.input-date'),i);
            $item_rate.appendTo($element);
            $item_rate.find('.btn-add-rate').on('click',function (e) {
                plugin.set_task_when_click(++i);
            });
            plugin.init_event_rate_item($item_rate);
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_rates = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_rates')) {
                var plugin = new $.field_rates(this, options);
                $(this).data('field_rates', plugin);
            }
        });
    }
})(jQuery);
