<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
    $item->text = $item->countryname;
}
$data = $displayData['field']->getForm()->getData();
$uri = Factory::getUri();
if($uri->getVar('page','') == 'wb_hotel' && $uri->getVar('id',0) > 0) {
    $modelHotel = Model::getInstance('hotel');
    $hotel = $modelHotel->getItem($uri->getVar('id',0));
    $phone_code = $hotel->phonecode;
    $current_country = $hotel->country_name;
    $country_code = $hotel->countrycode;
} elseif ($uri->getVar('page','') == 'wb_customer' && $uri->getVar('id',0) > 0) {
    $modelCustomer = Model::getInstance('customer');
    $customer = $modelCustomer->getItem($uri->getVar('id',0));
    $phone_code = $customer->phonecode;
    $current_country = $customer->country_name;
    $country_code = $customer->countrycode;
} elseif ($uri->getVar('page','') == 'wb_sms' && $uri->getVar('id',0) > 0) {
    $modelSms = Model::getInstance('sms');
    $sms = $modelSms->getItem($uri->getVar('id',0));
    $phone_code = $sms->phonecode;
    $current_country = $sms->country_name;
    $country_code = $sms->countrycode;
}  elseif ($uri->getVar('page','') == 'wb_location' && $uri->getVar('id',0) > 0) {
    $modelLocation = Model::getInstance('location');
    $location = $modelLocation->getItem($uri->getVar('id',0));
    $phone_code = $location->phonecode;
    $current_country = $location->country_name;
    $country_code = $location->countrycode;
}  else {
    $phone_code = $default_phone_code;
    $current_country="United States";
    $country_code = "USA";
}


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input class="countries" value="" type="text">
            <input type="hidden" name="<?php echo (esc_attr($field_name_phone_code)) ?>" value="<?php echo (esc_attr($phone_code)) ?>">
            <input type="hidden" name="<?php echo (esc_attr($field_name_countrycode)) ?>" value="<?php echo (esc_attr($country_code)) ?>">
            <input class="phone_number" name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>"
                   type="text">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/phonenumber/phonenumber.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
    "field_name_phone_code"=>$field_name_phone_code,
    "field_name_countrycode"=>$field_name_countrycode,
    "phonecode"=>$phone_code,
    "current_country"=>$current_country,
    "countrycode"=>$country_code,
),'admin/app/layouts/WooBooking/form/field/phonenumber/phonenumber.jquery.js');