<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-opentime">
        <input type="text" id="open-time" class="form-control open-time" value="<?php esc_html_e($value);?>" />
        <input type="hidden" name="<?php esc_html_e($name);?>" />
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlWooPanel::load_jquery_library('moment');
WpBookingHotelHtmlWooPanel::load_jquery_library('daterangepicker');
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/opentime/opentime.less');
$doc->addScriptApplySelector('.element-field-opentime','field_opentime',array(
    'input_name'=>$name,
    'value'=>$value
),'admin_woopanel/app/layouts/WooBooking/form/field/opentime/opentime.jquery.js');
