<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$input=Factory::getInput();
$event_id=$input->getInt('id',0);
if($event_id > 0) {
    $modelEvent = Model::getInstance('event');
    $event=$modelEvent->getItem($event_id);
    $open_date = Factory::getDate($event->open_date);
    if (!$open_date->getTimestamp()) {
        $open_date = clone Factory::getDate();
    }
    $open_date = $open_date->toSql();
} else {
    $open_date = null;
}
$now = date('Y-m-d H:i:s');
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="element-field-open-date <?php echo(isset($open_date)?'hide-option':'');?>">
        <div class="wrapper-label">
            <input type="checkbox" id="opendate-ckb"  name="<?php esc_html_e($name); ?>" />
            <label class="opendate-label" for="opendate-ckb">
                <?php esc_attr_e('Booking open immediately','wpbookinghotel')?>
            </label>
        </div>
        <div class="option form-horizontal invisible">
            <div class="block-select-open-date">
                <label for="until-when" class="control-label"><?php esc_attr_e('Open on','wpbookinghotel') ?>:</label>
                <div class="select-open-date">
                    <input type="text" class="form-control open-date" id="open-date" value="<?php echo(isset($open_date) ? $open_date : $now) ?>" />
                    <input type="hidden"  name="<?php echo (esc_attr($name_open_date)) ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/opendate/opendate.less');
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
WpBookingHotelHtmlWooPanel::load_jquery_library('moment');
WpBookingHotelHtmlWooPanel::load_jquery_library('daterangepicker');
WpBookingHotelHtmlWooPanel::load_jquery_library('icheck');
$doc->addScriptApplySelector('.element-field-open-date','field_opendate',array(
    "input_name"=>$name_open_date,
    "open_date"=>isset($open_date) ? $open_date : $now
),'admin_woopanel/app/layouts/WooBooking/form/field/opendate/opendate.jquery.js');
