<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$locationsModel = Model::getInstance('locations');
$list_location = $locationsModel->getList();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-location">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : null) ?>
                class="form-control list-location">
            <option value=""><?php esc_html_e('Select location','wpbookinghotel');?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo ($value == $location->id ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($location->id)); ?>"><?php esc_html_e($location->address,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/location/location.less');
$doc->addScriptApplySelector('.field-location','field_location',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/location/location.jquery.js');
