<?php
use WpBookingHotel\Language\Text;
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelHotels = Model::getInstance('hotels');
$list = $modelHotels->getList();
$list_time = [];
$list_hotel_id = [];
if (!is_array($value)) {
	$list_hotel_id[] = $value;
} else {
	$list_hotel_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-hotel">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-hotel">
            <option value=""><?php esc_html_e('Select hotel','wpbookinghotel') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->id, $list_hotel_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/hotel/hotel.less');
$doc->addScriptApplySelector('.field-hotel','field_hotel',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/hotel/hotel.jquery.js');