<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('ui');
$doc = Factory::getDocument();
$id_by_name = "element_field_". $name;
$images = $value;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-gallery hide-option">
        <ul class="list-image">
            <?php if($images) {?>
                <?php foreach ($images as $image) { ?>
                    <li data-id="<?php echo (esc_attr($image->id)); ?>" class="image-item"><i
                                class="far fa-trash-alt remove"></i><img class="image"
                                                                         src="<?php echo(Factory::getRootUrlPlugin() .$image->path); ?>">
                    </li>
                <?php } ?>
			<?php } ?>
            <li>
                <div class="upload"><i class="far fa-plus-square"></i></div>
            </li>
        </ul>
		<?php if ($enable_upload) { ?>
            <input type="file" class="upload upload-file item-image" style="display: none"/>
		<?php } else { ?>
            <div class="btn-browser-media"></div>
		<?php } ?>
        <input type="hidden" name="<?php echo (esc_attr($name_field_deleted)) ?>" class="deleted" style="display: none" value=""/>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/gallery/gallery.less');
$doc->addScriptApplySelector('.field-gallery','field_gallery',array(
    "input_name"=>  $name,
    "name_field_deleted"=>  $name_field_deleted,
    "enable_upload"=>  (boolean)$enable_upload,
    "multiple"=>  (boolean)$multiple,
),'admin_woopanel/app/layouts/WooBooking/form/field/gallery/gallery.jquery.js');