<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelEvents = Model::getInstance('events');
$list = $modelEvents->getList();
$list_event_id = [];
if (!is_array($value)) {
    $list_event_id[] = $value;
} else {
    $list_event_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-events">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo($multiple ? ' multiple ' : ''); ?>
                class="list-event">
            <option value=""><?php esc_html_e('Select event','wpbookinghotel'); ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo(in_array($item->id, $list_event_id) ? ' selected ' : ''); ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/events/events.less');
$doc->addScriptApplySelector('.field-events','field_events',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/events/events.js');