<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model as ModelAlias;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('auto_numeric');
$doc = Factory::getDocument();
$employeesModel= ModelAlias::getInstance('employees');
$list_employees =$employeesModel->getList();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-employeeservice">
        <div class="wrapper-employeeservice">
            <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-employeeservice">
                <option value="" disabled> <?php esc_html_e('Select employees','wpbookinghotel') ?></option>
                <?php foreach ($list_employees as $employee) { ?>
                    <option <?php echo (in_array($employee->id, $list_selected) ? " selected " : "") ?>
                            value="<?php echo (esc_attr($employee->id)); ?>" ><?php echo($employee->first_name . ' '. $employee->last_name); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/employeeservice/employeeservice.less');
$doc->addScriptApplySelector("#$id_by_name",'field_employeeservice',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/employeeservice/jquery.employeeservice.js');
