<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotelAdmin\app\helpers\EmailHelper;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_email_type=EmailHelper::get_list_email_type();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-emailtype">
        <select name="<?php echo (esc_attr($name)); ?>"
                class="form-control list-emailtype">
            <option value=""><?php esc_attr_e('Select email type','wpbookinghotel')?></option>
            <?php foreach ($list_email_type as $item) { ?>
                <option <?php echo (EmailHelper::check_in_array_mail_type($value) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($item->type)); ?>"><?php esc_html_e($item->description,'wpbookinghotel'); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/emailtype/emailtype.less');
$doc->addScriptApplySelector('.field-emailtype','field_emailtype',array(
        'field_name'=> $name
),'admin_woopanel/app/layouts/WooBooking/form/field/emailtype/emailtype.js');