<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('auto_numeric');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/customaddress/customaddress.less');
$modelLocation = Model::getInstance('location');
$list = $modelLocation->getList();
$id_by_name = "element_field_". $name;
?>
    <div id="<?php echo (esc_html($id_by_name)) ?>" class="field-custom-address">
        <label class="label-select-address"><?php esc_attr_e('Select address','wpbookinghotel') ?></label>
        <div class="block-select-address">
            <select name="<?php echo (esc_html($name)); ?>" class="list-address">
                <option value=""><?php esc_attr_e('Custom address','wpbookinghotel') ?></option>
                <?php foreach ($list as $item) { ?>
                    <option <?php echo($value == $item->id ? ' selected ' : '') ?>
                            value="<?php echo (esc_html($item->id)); ?>"><?php esc_html_e($item->address,'wpbookinghotel'); ?></option>
                <?php } ?>
            </select>
        </div>
        <div class="wrapper-custom-address">
            <div class="row">
                <div class="col-md-12">
                    <input type="text" class="form-control custom-address" name="<?php echo (esc_attr($name_custom_address)) ?>" placeholder="<?php esc_attr_e('Custom address','wpbookinghotel') ?>"  />
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('#'.$id_by_name,'field_customaddress',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/customaddress/jquery.customaddress.js');
