<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . $name;
$data = $field->getForm()->getData();
$a_title = $data->def('name');
$fullname = ucwords($data->def('first_name') . ' ' . $data->def('last_name'));
$image = $data->def('image_location_avatar');
$a_title = Utility::clean($a_title);
$a_title = Utility::clean_all_space_to_single_space($a_title);
$arrName = explode(' ', $a_title);
$arrName = array_splice($arrName, 0, 3);
$iconImg = [];
for ($i = 0; $i < count($arrName); $i++) {
	$iconImg[] = mb_substr($arrName[$i], 0, 1, "UTF-8");
}
$iconImg = implode(" ", $iconImg);
$iconImg = strtoupper($iconImg);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-cover">
        <div class="wrapper-field-cover">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div>
                    <img class="img-avatar" src="<?php esc_html_e(Factory::getRootUrlPlugin())  ?>/<?php echo ($value ? $value : $default) ?>" alt="avatar" />
                </div>
                <span><?php echo ($image == "" || $image == null) ? $iconImg : "" ?></span>
            </div>
            <p><?php echo (($a_title) ? $a_title : $fullname) ?></p>
            <input type="file" class="upload"  name="<?php esc_html_e($name); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/cover/cover.less');
$doc->addScriptApplySelector("#$id_by_name",'field_cover',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/cover/cover.jquery.js');