<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$input=Factory::getInput();
$event_id=$input->getInt('id',0);
$list_rate_from = [];
$now = date('Y-m-d H:i:s');
if($event_id > 0) {
    $modelEvent = Model::getInstance('event');
    $event=$modelEvent->getItem($event_id);
    $close_date = Factory::getDate($event->close_date);
    $rates = $event->rates;
    foreach ($rates as $rate) {
        array_push($list_rate_from, $rate->from);
    }
    if (!$close_date->getTimestamp()) {
        $close_date = clone Factory::getDate();
    }
    $close_date = $close_date->toSql();
} else {
    $close_date = null;
}

if(count((array)$list_rate_from) > 0) {
    $min_date_from = min((array)$list_rate_from);
} else {
    $min_date_from = $now;
}
?>
    <div id="<?php echo (esc_html($id_by_name)) ?>" class="element-field-close-date <?php echo(isset($close_date)?'hide-option':'');?>">
        <div class="wrapper-label">
            <input type="checkbox" id="closedate-ckb" name="<?php echo (esc_html($name)); ?>" />
            <label class="closedate-label" for="closedate-ckb">
                <?php esc_attr_e('Booking closes when event starts','wpbookinghotel')?>
            </label>
        </div>
        <div class="option form-horizontal invisible">
            <div class="block-select-close-date">
                <label for="until-when" class="control-label"><?php esc_attr_e('Closes on','wpbookinghotel') ?>:</label>
                <div class="select-close-date">
                    <input type="text" id="close-date" class="form-control close-date" value="<?php echo(isset($close_date) ? $close_date : $now) ?>" />
                    <input type="hidden" name="<?php echo (esc_attr($name_close_date)); ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/closedate/closedate.less');
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
WpBookingHotelHtmlWooPanel::load_jquery_library('moment');
WpBookingHotelHtmlWooPanel::load_jquery_library('daterangepicker');
WpBookingHotelHtmlWooPanel::load_jquery_library('icheck');
$doc->addScriptApplySelector('.element-field-close-date','field_closedate',array(
    "input_name"=>$name_close_date,
    'close_date' => isset($close_date) ? $close_date : $now,
    'min_date_from'=>$min_date_from
),'admin_woopanel/app/layouts/WooBooking/form/field/closedate/closedate.jquery.js');
