"use strict";
(function ($) {
    $.field_closedate = function (element, options) {
        var defaults = {
            input_name:'',
            close_date:'',
            min_date_from:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let now = new Date();
            let close_date = plugin.settings.close_date;
            let min_date_from = plugin.settings.min_date_from;
            $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(close_date);
            $element.find('input[id="close-date"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                timePicker: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD HH:mm:ss'
                },
                maxYear: '+10',
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name['0']}"]`).val(start.format('YYYY-MM-DD HH:mm:ss'));
            });
            $element.find('.label').click(function (e) {
                if (!$(this).find('input[type="checkbox"]').is(':checked')) {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                } else {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '10%'
            }).on('ifChanged ', function(event) {
                if (!$(this).is(':checked')) {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                } else {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]#closedate-ckb').on('ifChecked', function () {
                $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(min_date_from);
            });
            $element.find('input[type="checkbox"]#closedate-ckb').on('ifUnchecked', function () {
                $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(close_date)
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.field_closedate = function (options) {
        return this.each(function () {
            
            if (undefined == $(this).data('field_closedate')) {
                var plugin = new $.field_closedate(this, options);
                $(this).data('field_closedate', plugin);
            }
        });
    }
})(jQuery);