<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-bookingstyle">
        <select class="list-bookingstyle" name="<?php echo (esc_attr($name)); ?>" >
            <option value=""><?php esc_html_e('Select booking style','wpbookinghotel') ?></option>
            <option <?php echo (($value == "in_line") ? ' selected ' : null) ?> value="in_line">
                <?php esc_html_e('Booking in line','wpbookinghotel') ?>
            </option>
            <option <?php echo (($value == "integrate") ? ' selected ' : null) ?> value="integrate" disabled >
                <?php esc_html_e('Integrate','wpbookinghotel') ?>
            </option>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/bookingstyle/bookingstyle.less');
$doc->addScriptApplySelector('.field-bookingstyle','field_bookingstyle',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/bookingstyle/bookingstyle.jquery.js');