<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model as ModelAlias;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlWooPanelAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlWooPanelAlias::load_jquery_library('select2');
$doc = Factory::getDocument();
$amenitiesModel= ModelAlias::getInstance('amenities');
$list_amenities =$amenitiesModel->getList();

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-amenity">
        <div class="wrapper-amenity">
            <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-amenity">
                <option value="" disabled> <?php esc_html_e('Select amenity','wpbookinghotel') ?></option>
                <?php foreach ($list_amenities as $amenity) { ?>
                    <option <?php echo (in_array($amenity->id, $list_selected) ? " selected " : "") ?>
                            value="<?php echo (esc_attr($amenity->id)); ?>" ><?php esc_html_e($amenity->name,'wpbookinghotel'); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/amenity/amenity.less');
$doc->addScriptApplySelector("#$id_by_name",'field_amenity',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/amenity/jquery.amenity.js');
