<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlWooPanel;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$list_actionsms = array('first_send','second_send');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-actionsms-<?php echo (esc_attr($name_format)) ?> field-actionsms">
        <select class="form-control list-actionsms" <?php echo ($multiple ? ' multiple ' : ""); ?>>
            <option value=""> <?php esc_html_e('Select action sms','wpbookinghotel') ?></option>
			<?php foreach ($list_actionsms as $actionsms) { ?>
                <option <?php echo ($actionsms == $value ? " selected " : "") ?>
                        value="<?php echo (esc_attr($actionsms)); ?>"><?php echo (esc_html(ucfirst(str_replace('_',' ', $actionsms)))); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/actionsms/actionsms.less');
$doc->addScriptApplySelector('.field-actionsms','field_actionsms',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin_woopanel/app/layouts/WooBooking/form/field/actionsms/actionsms.jquery.js');
