<?php
namespace WpBookingHotelAdminWooPanel\app\helpers;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model as ModelAlias;
use WpBookingHotel\Mvc\Table\Table;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;

class ConfigHelper extends AdminHelper
{
    public static function set_page_hotel($page_id,$type){
        $modelConfig = ModelAlias::getInstance('config');
        $table = $modelConfig->getTable();
        $table->load(1);
        $params = $table->params;
        $reg = new Registry();
        $reg->loadString($params);
        $reg->set($type,$page_id);
        $table->params = $reg->toString();
        $table->store();
    }
    public static function get_page_list_hotel(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_list_hotel',0);

    }
    public static function get_page_checkout_default(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_list_checkout_default',0);

    }
    public static function get_page_hotel_detail(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_hotel_detail',0);

    }

    public static function create_create_page($view,$type)
    {
        $a_view=str_replace("-"," ",$view);
        $key_page=$a_view;
        $tour_detail = array(
            'post_name' => "$key_page",
            'post_title' => $key_page,
            'post_content' => '[wpbookinghotel view="'.$view.'"]',
            'post_status' => "publish",
            'post_author' => get_current_user_id(),
            'post_type' => "page",
        );
        $post_id=wp_insert_post($tour_detail, '');
        self::set_page_hotel($post_id,$type);
    }

}